uniform mat4 inverseModelView;
uniform vec4 eyePosition;
uniform vec4 lightVector;
uniform mat4 boneMatrices[200];

attribute vec4 weights;
attribute vec4 matrixIndices;
attribute vec4 numBones;

void main( void )
{
 	vec4 index  = matrixIndices;
	vec4 weight = weights;

 	vec4 normal      = vec4( gl_Normal.xyz, 0.0 );
  	vec4 position    = vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempNormal  = vec4( 0.0, 0.0, 0.0, 0.0 );

  	for( float i = 0.0; i < numBones.x; i += 1.0 )
 	{
 	    // Apply influence of bone i
  	    position = position + weight.x * (boneMatrices[int(index.x)] * gl_Vertex);

  	    // Transform normal by bone i
  	    tempNormal = tempNormal + weight.x * (boneMatrices[int(index.x)] * normal);

  	    // shift over the index/weight variables, this moves the index and 
   	    // weight for the current bone into the .x component of the index 
   	    // and weight variables
   	    index  = index.yzwx;
		weight = weight.yzwx;
	}

	gl_Position = gl_ModelViewProjMatrix * position;


  	// gl_ModelViewMatrixInverse only works on nVIDIA cards so we'll need to 
 	// pass our own inverse model-view matrix until ATI adds support for it.
  	vec3 finalNormal = (normalize(tempNormal)).xyz;

	// insert shading computation
	// ...
}
